
#include <stdint.h>

// GF2^8
const uint16_t gf2_11_expTab[2050] = {
    1,    2,    4,    8,    16,   32,   64,   128,  256,  512,  1024, 5,    10,   20,   40,   80,   160,  320,  640,
    1280, 517,  1034, 17,   34,   68,   136,  272,  544,  1088, 133,  266,  532,  1064, 85,   170,  340,  680,  1360,
    677,  1354, 657,  1314, 577,  1154, 257,  514,  1028, 13,   26,   52,   104,  208,  416,  832,  1664, 1285, 527,
    1054, 57,   114,  228,  456,  912,  1824, 1605, 1167, 283,  566,  1132, 221,  442,  884,  1768, 1493, 943,  1886,
    1721, 1399, 747,  1494, 937,  1874, 1697, 1351, 651,  1302, 553,  1106, 161,  322,  644,  1288, 533,  1066, 81,
    162,  324,  648,  1296, 549,  1098, 145,  290,  580,  1160, 277,  554,  1108, 173,  346,  692,  1384, 725,  1450,
    849,  1698, 1345, 647,  1294, 537,  1074, 97,   194,  388,  776,  1552, 1061, 79,   158,  316,  632,  1264, 485,
    970,  1940, 1837, 1631, 1211, 371,  742,  1484, 925,  1850, 1649, 1255, 459,  918,  1836, 1629, 1215, 379,  758,
    1516, 989,  1978, 1905, 1767, 1483, 915,  1830, 1609, 1175, 299,  598,  1196, 349,  698,  1396, 749,  1498, 945,
    1890, 1729, 1415, 779,  1558, 1065, 87,   174,  348,  696,  1392, 741,  1482, 913,  1826, 1601, 1159, 267,  534,
    1068, 93,   186,  372,  744,  1488, 933,  1866, 1681, 1319, 587,  1174, 297,  594,  1188, 333,  666,  1332, 621,
    1242, 433,  866,  1732, 1421, 799,  1598, 1145, 247,  494,  988,  1976, 1909, 1775, 1499, 947,  1894, 1737, 1431,
    811,  1622, 1193, 343,  686,  1372, 701,  1402, 753,  1506, 961,  1922, 1793, 1543, 1035, 19,   38,   76,   152,
    304,  608,  1216, 389,  778,  1556, 1069, 95,   190,  380,  760,  1520, 997,  1994, 1937, 1831, 1611, 1171, 291,
    582,  1164, 285,  570,  1140, 237,  474,  948,  1896, 1749, 1455, 859,  1718, 1385, 727,  1454, 857,  1714, 1377,
    711,  1422, 793,  1586, 1121, 199,  398,  796,  1592, 1141, 239,  478,  956,  1912, 1781, 1519, 987,  1974, 1897,
    1751, 1451, 851,  1702, 1353, 663,  1326, 601,  1202, 353,  706,  1412, 781,  1562, 1073, 103,  206,  412,  824,
    1648, 1253, 463,  926,  1852, 1661, 1279, 507,  1014, 2028, 2013, 1983, 1915, 1779, 1507, 963,  1926, 1801, 1559,
    1067, 83,   166,  332,  664,  1328, 613,  1226, 401,  802,  1604, 1165, 287,  574,  1148, 253,  506,  1012, 2024,
    2005, 1967, 1883, 1715, 1379, 707,  1414, 777,  1554, 1057, 71,   142,  284,  568,  1136, 229,  458,  916,  1832,
    1621, 1199, 347,  694,  1388, 733,  1466, 881,  1762, 1473, 903,  1806, 1561, 1079, 107,  214,  428,  856,  1712,
    1381, 719,  1438, 825,  1650, 1249, 455,  910,  1820, 1597, 1151, 251,  502,  1004, 2008, 1973, 1903, 1755, 1459,
    867,  1734, 1417, 791,  1582, 1113, 183,  366,  732,  1464, 885,  1770, 1489, 935,  1870, 1689, 1335, 619,  1238,
    425,  850,  1700, 1357, 671,  1342, 633,  1266, 481,  962,  1924, 1805, 1567, 1083, 115,  230,  460,  920,  1840,
    1637, 1231, 411,  822,  1644, 1245, 447,  894,  1788, 1533, 1023, 2046, 2041, 2039, 2027, 2003, 1955, 1859, 1667,
    1283, 515,  1030, 9,    18,   36,   72,   144,  288,  576,  1152, 261,  522,  1044, 45,   90,   180,  360,  720,
    1440, 837,  1674, 1297, 551,  1102, 153,  306,  612,  1224, 405,  810,  1620, 1197, 351,  702,  1404, 765,  1530,
    1009, 2018, 1985, 1927, 1803, 1555, 1059, 67,   134,  268,  536,  1072, 101,  202,  404,  808,  1616, 1189, 335,
    670,  1340, 637,  1274, 497,  994,  1988, 1933, 1823, 1595, 1139, 227,  454,  908,  1816, 1589, 1135, 219,  438,
    876,  1752, 1461, 879,  1758, 1465, 887,  1774, 1497, 951,  1902, 1753, 1463, 875,  1750, 1449, 855,  1710, 1369,
    695,  1390, 729,  1458, 865,  1730, 1409, 775,  1550, 1049, 55,   110,  220,  440,  880,  1760, 1477, 911,  1822,
    1593, 1143, 235,  470,  940,  1880, 1717, 1391, 731,  1462, 873,  1746, 1441, 839,  1678, 1305, 567,  1134, 217,
    434,  868,  1736, 1429, 815,  1630, 1209, 375,  750,  1500, 957,  1914, 1777, 1511, 971,  1942, 1833, 1623, 1195,
    339,  678,  1356, 669,  1338, 625,  1250, 449,  898,  1796, 1549, 1055, 59,   118,  236,  472,  944,  1888, 1733,
    1423, 795,  1590, 1129, 215,  430,  860,  1720, 1397, 751,  1502, 953,  1906, 1761, 1479, 907,  1814, 1577, 1111,
    171,  342,  684,  1368, 693,  1386, 721,  1442, 833,  1666, 1281, 519,  1038, 25,   50,   100,  200,  400,  800,
    1600, 1157, 271,  542,  1084, 125,  250,  500,  1000, 2000, 1957, 1871, 1691, 1331, 611,  1222, 393,  786,  1572,
    1101, 159,  318,  636,  1272, 501,  1002, 2004, 1965, 1887, 1723, 1395, 739,  1478, 905,  1810, 1569, 1095, 139,
    278,  556,  1112, 181,  362,  724,  1448, 853,  1706, 1361, 679,  1358, 665,  1330, 609,  1218, 385,  770,  1540,
    1037, 31,   62,   124,  248,  496,  992,  1984, 1925, 1807, 1563, 1075, 99,   198,  396,  792,  1584, 1125, 207,
    414,  828,  1656, 1269, 495,  990,  1980, 1917, 1791, 1531, 1011, 2022, 1993, 1943, 1835, 1619, 1187, 323,  646,
    1292, 541,  1082, 113,  226,  452,  904,  1808, 1573, 1103, 155,  310,  620,  1240, 437,  874,  1748, 1453, 863,
    1726, 1401, 759,  1518, 985,  1970, 1889, 1735, 1419, 787,  1574, 1097, 151,  302,  604,  1208, 373,  746,  1492,
    941,  1882, 1713, 1383, 715,  1430, 809,  1618, 1185, 327,  654,  1308, 573,  1146, 241,  482,  964,  1928, 1813,
    1583, 1115, 179,  358,  716,  1432, 821,  1642, 1233, 423,  846,  1692, 1341, 639,  1278, 505,  1010, 2020, 1997,
    1951, 1851, 1651, 1251, 451,  902,  1804, 1565, 1087, 123,  246,  492,  984,  1968, 1893, 1743, 1435, 819,  1638,
    1225, 407,  814,  1628, 1213, 383,  766,  1532, 1021, 2042, 2033, 2023, 1995, 1939, 1827, 1603, 1155, 259,  518,
    1036, 29,   58,   116,  232,  464,  928,  1856, 1669, 1295, 539,  1078, 105,  210,  420,  840,  1680, 1317, 591,
    1182, 313,  626,  1252, 461,  922,  1844, 1645, 1247, 443,  886,  1772, 1501, 959,  1918, 1785, 1527, 1003, 2006,
    1961, 1879, 1707, 1363, 675,  1350, 649,  1298, 545,  1090, 129,  258,  516,  1032, 21,   42,   84,   168,  336,
    672,  1344, 645,  1290, 529,  1058, 65,   130,  260,  520,  1040, 37,   74,   148,  296,  592,  1184, 325,  650,
    1300, 557,  1114, 177,  354,  708,  1416, 789,  1578, 1105, 167,  334,  668,  1336, 629,  1258, 465,  930,  1860,
    1677, 1311, 571,  1142, 233,  466,  932,  1864, 1685, 1327, 603,  1206, 361,  722,  1444, 845,  1690, 1329, 615,
    1230, 409,  818,  1636, 1229, 415,  830,  1660, 1277, 511,  1022, 2044, 2045, 2047, 2043, 2035, 2019, 1987, 1923,
    1795, 1539, 1027, 3,    6,    12,   24,   48,   96,   192,  384,  768,  1536, 1029, 15,   30,   60,   120,  240,
    480,  960,  1920, 1797, 1551, 1051, 51,   102,  204,  408,  816,  1632, 1221, 399,  798,  1596, 1149, 255,  510,
    1020, 2040, 2037, 2031, 2011, 1971, 1891, 1731, 1411, 771,  1542, 1033, 23,   46,   92,   184,  368,  736,  1472,
    901,  1802, 1553, 1063, 75,   150,  300,  600,  1200, 357,  714,  1428, 813,  1626, 1201, 359,  718,  1436, 829,
    1658, 1265, 487,  974,  1948, 1853, 1663, 1275, 499,  998,  1996, 1949, 1855, 1659, 1267, 483,  966,  1932, 1821,
    1599, 1147, 243,  486,  972,  1944, 1845, 1647, 1243, 435,  870,  1740, 1437, 831,  1662, 1273, 503,  1006, 2012,
    1981, 1919, 1787, 1523, 995,  1990, 1929, 1815, 1579, 1107, 163,  326,  652,  1304, 565,  1130, 209,  418,  836,
    1672, 1301, 559,  1118, 185,  370,  740,  1480, 917,  1834, 1617, 1191, 331,  662,  1324, 605,  1210, 369,  738,
    1476, 909,  1818, 1585, 1127, 203,  406,  812,  1624, 1205, 367,  734,  1468, 893,  1786, 1521, 999,  1998, 1945,
    1847, 1643, 1235, 419,  838,  1676, 1309, 575,  1150, 249,  498,  996,  1992, 1941, 1839, 1627, 1203, 355,  710,
    1420, 797,  1594, 1137, 231,  462,  924,  1848, 1653, 1263, 475,  950,  1900, 1757, 1471, 891,  1782, 1513, 983,
    1966, 1881, 1719, 1387, 723,  1446, 841,  1682, 1313, 583,  1166, 281,  562,  1124, 205,  410,  820,  1640, 1237,
    431,  862,  1724, 1405, 767,  1534, 1017, 2034, 2017, 1991, 1931, 1811, 1571, 1091, 131,  262,  524,  1048, 53,
    106,  212,  424,  848,  1696, 1349, 655,  1310, 569,  1138, 225,  450,  900,  1800, 1557, 1071, 91,   182,  364,
    728,  1456, 869,  1738, 1425, 807,  1614, 1177, 311,  622,  1244, 445,  890,  1780, 1517, 991,  1982, 1913, 1783,
    1515, 979,  1958, 1865, 1687, 1323, 595,  1190, 329,  658,  1316, 589,  1178, 305,  610,  1220, 397,  794,  1588,
    1133, 223,  446,  892,  1784, 1525, 1007, 2014, 1977, 1911, 1771, 1491, 931,  1862, 1673, 1303, 555,  1110, 169,
    338,  676,  1352, 661,  1322, 593,  1186, 321,  642,  1284, 525,  1050, 49,   98,   196,  392,  784,  1568, 1093,
    143,  286,  572,  1144, 245,  490,  980,  1960, 1877, 1711, 1371, 691,  1382, 713,  1426, 801,  1602, 1153, 263,
    526,  1052, 61,   122,  244,  488,  976,  1952, 1861, 1679, 1307, 563,  1126, 201,  402,  804,  1608, 1173, 303,
    606,  1212, 381,  762,  1524, 1005, 2010, 1969, 1895, 1739, 1427, 803,  1606, 1161, 279,  558,  1116, 189,  378,
    756,  1512, 981,  1962, 1873, 1703, 1355, 659,  1318, 585,  1170, 289,  578,  1156, 269,  538,  1076, 109,  218,
    436,  872,  1744, 1445, 847,  1694, 1337, 631,  1262, 473,  946,  1892, 1741, 1439, 827,  1654, 1257, 471,  942,
    1884, 1725, 1407, 763,  1526, 1001, 2002, 1953, 1863, 1675, 1299, 547,  1094, 137,  274,  548,  1096, 149,  298,
    596,  1192, 341,  682,  1364, 685,  1370, 689,  1378, 705,  1410, 769,  1538, 1025, 7,    14,   28,   56,   112,
    224,  448,  896,  1792, 1541, 1039, 27,   54,   108,  216,  432,  864,  1728, 1413, 783,  1566, 1081, 119,  238,
    476,  952,  1904, 1765, 1487, 923,  1846, 1641, 1239, 427,  854,  1708, 1373, 703,  1406, 761,  1522, 993,  1986,
    1921, 1799, 1547, 1043, 35,   70,   140,  280,  560,  1120, 197,  394,  788,  1576, 1109, 175,  350,  700,  1400,
    757,  1514, 977,  1954, 1857, 1671, 1291, 531,  1062, 73,   146,  292,  584,  1168, 293,  586,  1172, 301,  602,
    1204, 365,  730,  1460, 877,  1754, 1457, 871,  1742, 1433, 823,  1646, 1241, 439,  878,  1756, 1469, 895,  1790,
    1529, 1015, 2030, 2009, 1975, 1899, 1747, 1443, 835,  1670, 1289, 535,  1070, 89,   178,  356,  712,  1424, 805,
    1610, 1169, 295,  590,  1180, 317,  634,  1268, 493,  986,  1972, 1901, 1759, 1467, 883,  1766, 1481, 919,  1838,
    1625, 1207, 363,  726,  1452, 861,  1722, 1393, 743,  1486, 921,  1842, 1633, 1223, 395,  790,  1580, 1117, 191,
    382,  764,  1528, 1013, 2026, 2001, 1959, 1867, 1683, 1315, 579,  1158, 265,  530,  1060, 77,   154,  308,  616,
    1232, 421,  842,  1684, 1325, 607,  1214, 377,  754,  1508, 973,  1946, 1841, 1639, 1227, 403,  806,  1612, 1181,
    319,  638,  1276, 509,  1018, 2036, 2029, 2015, 1979, 1907, 1763, 1475, 899,  1798, 1545, 1047, 43,   86,   172,
    344,  688,  1376, 709,  1418, 785,  1570, 1089, 135,  270,  540,  1080, 117,  234,  468,  936,  1872, 1701, 1359,
    667,  1334, 617,  1234, 417,  834,  1668, 1293, 543,  1086, 121,  242,  484,  968,  1936, 1829, 1615, 1179, 307,
    614,  1228, 413,  826,  1652, 1261, 479,  958,  1916, 1789, 1535, 1019, 2038, 2025, 2007, 1963, 1875, 1699, 1347,
    643,  1286, 521,  1042, 33,   66,   132,  264,  528,  1056, 69,   138,  276,  552,  1104, 165,  330,  660,  1320,
    597,  1194, 337,  674,  1348, 653,  1306, 561,  1122, 193,  386,  772,  1544, 1045, 47,   94,   188,  376,  752,
    1504, 965,  1930, 1809, 1575, 1099, 147,  294,  588,  1176, 309,  618,  1236, 429,  858,  1716, 1389, 735,  1470,
    889,  1778, 1505, 967,  1934, 1817, 1591, 1131, 211,  422,  844,  1688, 1333, 623,  1246, 441,  882,  1764, 1485,
    927,  1854, 1657, 1271, 491,  982,  1964, 1885, 1727, 1403, 755,  1510, 969,  1938, 1825, 1607, 1163, 275,  550,
    1100, 157,  314,  628,  1256, 469,  938,  1876, 1709, 1375, 699,  1398, 745,  1490, 929,  1858, 1665, 1287, 523,
    1046, 41,   82,   164,  328,  656,  1312, 581,  1162, 273,  546,  1092, 141,  282,  564,  1128, 213,  426,  852,
    1704, 1365, 687,  1374, 697,  1394, 737,  1474, 897,  1794, 1537, 1031, 11,   22,   44,   88,   176,  352,  704,
    1408, 773,  1546, 1041, 39,   78,   156,  312,  624,  1248, 453,  906,  1812, 1581, 1119, 187,  374,  748,  1496,
    949,  1898, 1745, 1447, 843,  1686, 1321, 599,  1198, 345,  690,  1380, 717,  1434, 817,  1634, 1217, 391,  782,
    1564, 1085, 127,  254,  508,  1016, 2032, 2021, 1999, 1947, 1843, 1635, 1219, 387,  774,  1548, 1053, 63,   126,
    252,  504,  1008, 2016, 1989, 1935, 1819, 1587, 1123, 195,  390,  780,  1560, 1077, 111,  222,  444,  888,  1776,
    1509, 975,  1950, 1849, 1655, 1259, 467,  934,  1868, 1693, 1343, 635,  1270, 489,  978,  1956, 1869, 1695, 1339,
    627,  1254, 457,  914,  1828, 1613, 1183, 315,  630,  1260, 477,  954,  1908, 1773, 1503, 955,  1910, 1769, 1495,
    939,  1878, 1705, 1367, 683,  1366, 681,  1362, 673,  1346, 641,  1282, 513,  1026, 1,    2,    4};

const uint16_t gf2_11_logTab[2048] = {
    2048, 0,    1,    1029, 2,    11,   1030, 1496, 3,    478,  12,   1912, 1031, 47,   1497, 1040, 4,    22,   479,
    243,  13,   945,  1913, 1076, 1032, 678,  48,   1507, 1498, 894,  1041, 742,  5,    1771, 23,   1543, 480,  961,
    244,  1923, 14,   1882, 946,  1707, 1914, 489,  1077, 1800, 1033, 1361, 679,  1051, 49,   1272, 1508, 580,  1499,
    58,   895,  639,  1042, 1389, 743,  1974, 6,    956,  1772, 520,  24,   1777, 1544, 371,  481,  1567, 962,  1087,
    245,  1668, 1924, 127,  15,   94,   1883, 343,  947,  33,   1708, 177,  1915, 1609, 490,  1289, 1078, 191,  1801,
    254,  1034, 121,  1362, 753,  680,  525,  1052, 319,  50,   905,  1273, 394,  1509, 1442, 581,  1990, 1500, 782,
    59,   451,  896,  1722, 640,  1518, 1043, 1739, 1390, 864,  744,  689,  1975, 1959, 7,    941,  957,  1268, 1773,
    29,   521,  1718, 25,   1476, 1778, 721,  1545, 1893, 372,  1368, 482,  101,  1568, 1811, 963,  1480, 1088, 810,
    246,  500,  1669, 789,  1925, 1863, 128,  704,  16,   88,   95,   1150, 1884, 1782, 344,  979,  948,  1348, 34,
    665,  1709, 108,  178,  1554, 1916, 972,  1610, 838,  491,  725,  1290, 424,  1079, 1163, 192,  1934, 1802, 1423,
    255,  1652, 1035, 1795, 122,  1985, 1363, 1549, 754,  290,  681,  1400, 526,  1183, 1053, 1249, 320,  759,  51,
    1156, 906,  1832, 1274, 1897, 395,  650,  1510, 607,  1443, 549,  582,  69,   1991, 1331, 1501, 1283, 783,  543,
    60,   376,  452,  1220, 897,  992,  1723, 591,  641,  271,  1519, 295,  1044, 831,  1740, 1123, 1391, 1372, 865,
    217,  745,  1206, 690,  410,  1976, 357,  1960, 1062, 8,    44,   942,  891,  958,  486,  1269, 1386, 1774, 1665,
    30,   188,  522,  1439, 1719, 686,  26,   1890, 1477, 1860, 1779, 105,  722,  1420, 1546, 1246, 1894, 66,   373,
    268,  1369, 354,  483,  1436, 102,  265,  1569, 1572, 1812, 1617, 964,  202,  1481, 162,  1089, 1575, 811,  1405,
    247,  1324, 501,  1747, 1670, 1815, 790,  1300, 1926, 913,  1864, 2021, 129,  1620, 705,  1691, 17,   1356, 89,
    777,  96,   967,  1151, 826,  1885, 1319, 1783, 1171, 345,  205,  980,  531,  949,  1788, 1349, 627,  35,   1484,
    666,  231,  1710, 1947, 109,  382,  179,  165,  1555, 508,  1917, 313,  973,  1214, 1611, 1092, 839,  1098, 492,
    1000, 726,  1636, 1291, 1578, 425,  1188, 1080, 1176, 1164, 138,  193,  814,  1935, 615,  1803, 1679, 1424, 150,
    256,  1408, 1653, 879,  1036, 738,  1796, 1970, 123,  250,  1986, 1955, 1364, 700,  1550, 1648, 755,  1327, 291,
    1058, 682,  350,  1401, 1687, 527,  504,  1184, 875,  1054, 1008, 1250, 458,  321,  1750, 760,  1012, 52,   1733,
    1157, 1200, 907,  1673, 1833, 845,  1275, 437,  1898, 1529, 396,  1818, 651,  1254, 1511, 210,  608,  1130, 1444,
    793,  550,  1590, 583,  1839, 70,   921,  1992, 1303, 1332, 462,  1502, 634,  1284, 859,  784,  1929, 544,  405,
    61,   2016, 377,  145,  453,  916,  1221, 325,  898,  985,  993,  2001, 1724, 1867, 592,  1461, 642,  1453, 272,
    1226, 1520, 2024, 296,  1754, 1045, 445,  832,  1117, 1741, 132,  1124, 1104, 1392, 2008, 1373, 1847, 866,  1623,
    218,  764,  746,  536,  1207, 1110, 691,  708,  411,  1137, 1977, 851,  358,  330,  1961, 1694, 1063, 1016, 9,
    2045, 45,   476,  943,  20,   892,  676,  959,  1769, 487,  1880, 1270, 1359, 1387, 56,   1775, 954,  1666, 1565,
    31,   92,   189,  1607, 523,  119,  1440, 903,  1720, 780,  687,  1737, 27,   939,  1891, 1474, 1478, 99,   1861,
    498,  1780, 86,   106,  1346, 723,  970,  1421, 1161, 1547, 1793, 1247, 1398, 1895, 1154, 67,   605,  374,  1281,
    269,  990,  1370, 829,  355,  1204, 484,  42,   1437, 1663, 103,  1888, 266,  1244, 1570, 1434, 1573, 200,  1813,
    1322, 1618, 911,  965,  1354, 203,  1317, 1482, 1786, 163,  1945, 1090, 311,  1576, 998,  812,  1174, 1406, 1677,
    248,  736,  1325, 698,  502,  348,  1748, 1006, 1671, 1731, 1816, 435,  791,  208,  1301, 1837, 1927, 632,  914,
    2014, 1865, 983,  2022, 1451, 130,  443,  1621, 2006, 706,  534,  1692, 849,  18,   2043, 1357, 1767, 90,   952,
    778,  117,  97,   937,  968,  84,   1152, 1791, 827,  1279, 1886, 40,   1320, 1432, 1784, 1352, 1172, 309,  346,
    734,  206,  1729, 981,  630,  532,  441,  950,  2041, 1789, 935,  1350, 38,   628,  732,  36,   2039, 1485, 2037,
    667,  1487, 232,  1902, 1711, 1489, 1948, 1379, 110,  669,  383,  570,  180,  1904, 166,  1872, 1556, 234,  509,
    1533, 1918, 1491, 314,  366,  974,  1713, 1215, 285,  1612, 1381, 1093, 821,  840,  1950, 1099, 400,  493,  671,
    1001, 1239, 727,  112,  1637, 280,  1292, 572,  1579, 597,  426,  385,  1189, 1822, 1081, 1906, 1177, 715,  1165,
    182,  139,  1642, 194,  1874, 815,  78,   1936, 168,  616,  655,  1804, 236,  1680, 1853, 1425, 1558, 151,  800,
    257,  1535, 1409, 1466, 1654, 511,  880,  1258, 1037, 1493, 739,  1073, 1797, 1920, 1971, 577,  124,  368,  251,
    174,  1987, 316,  1956, 1515, 1365, 1715, 701,  807,  1551, 976,  1649, 421,  756,  287,  1328, 647,  292,  1217,
    1059, 214,  683,  1383, 351,  1417, 1402, 1614, 1688, 1297, 528,  823,  505,  228,  1185, 1095, 876,  612,  1055,
    1952, 1009, 872,  1251, 842,  459,  1587, 322,  402,  1751, 1458, 761,  1101, 1013, 1134, 53,   673,  1734, 1604,
    1158, 495,  1201, 602,  908,  1241, 1674, 1942, 1834, 1003, 846,  1448, 1276, 114,  438,  306,  1899, 729,  1530,
    567,  397,  282,  1819, 277,  652,  1639, 1255, 797,  1512, 574,  211,  418,  609,  1294, 1131, 1584, 1445, 599,
    794,  564,  551,  1581, 1591, 554,  584,  387,  1840, 1629, 71,   428,  922,  557,  1993, 1824, 1304, 1231, 1333,
    1191, 463,  1594, 1503, 1908, 635,  1703, 1285, 1083, 860,  390,  785,  717,  1930, 661,  545,  1179, 406,  587,
    62,   184,  2017, 158,  378,  1167, 146,  1632, 454,  1644, 917,  1525, 1222, 141,  326,  1843, 899,  1876, 986,
    1342, 994,  196,  2002, 431,  1725, 80,   1868, 2033, 593,  817,  1462, 74,   643,  170,  1454, 224,  273,  1938,
    1227, 560,  1521, 657,  2025, 2029, 297,  618,  1755, 925,  1046, 238,  446,  338,  833,  1806, 1118, 1827, 1742,
    1855, 133,  622,  1125, 1682, 1105, 1996, 1393, 1560, 2009, 1312, 1374, 1427, 1848, 1234, 867,  802,  1624, 301,
    219,  153,  765,  1307, 747,  1537, 537,  1144, 1208, 259,  1111, 1194, 692,  1468, 709,  929,  412,  1411, 1138,
    1336, 1978, 513,  852,  770,  359,  1656, 331,  1597, 1962, 1260, 1695, 1759, 1064, 882,  1017, 466,  10,   1495,
    2046, 1028, 46,   1039, 477,  1911, 944,  1075, 21,   242,  893,  741,  677,  1506, 960,  1922, 1770, 1542, 488,
    1799, 1881, 1706, 1271, 579,  1360, 1050, 1388, 1973, 57,   638,  1776, 370,  955,  519,  1667, 126,  1566, 1086,
    32,   176,  93,   342,  190,  253,  1608, 1288, 524,  318,  120,  752,  1441, 1989, 904,  393,  1721, 1517, 781,
    450,  688,  1958, 1738, 863,  28,   1717, 940,  1267, 1892, 1367, 1475, 720,  1479, 809,  100,  1810, 1862, 703,
    499,  788,  1781, 978,  87,   1149, 107,  1553, 1347, 664,  724,  423,  971,  837,  1422, 1651, 1162, 1933, 1548,
    289,  1794, 1984, 1248, 758,  1399, 1182, 1896, 649,  1155, 1831, 68,   1330, 606,  548,  375,  1219, 1282, 542,
    270,  294,  991,  590,  1371, 216,  830,  1122, 356,  1061, 1205, 409,  485,  1385, 43,   890,  1438, 685,  1664,
    187,  104,  1419, 1889, 1859, 267,  353,  1245, 65,   1571, 1616, 1435, 264,  1574, 1404, 201,  161,  1814, 1299,
    1323, 1746, 1619, 1690, 912,  2020, 966,  825,  1355, 776,  204,  530,  1318, 1170, 1483, 230,  1787, 626,  164,
    507,  1946, 381,  1091, 1097, 312,  1213, 1577, 1187, 999,  1635, 813,  614,  1175, 137,  1407, 878,  1678, 149,
    249,  1954, 737,  1969, 1326, 1057, 699,  1647, 503,  874,  349,  1686, 1749, 1011, 1007, 457,  1672, 844,  1732,
    1199, 1817, 1253, 436,  1528, 792,  1589, 209,  1129, 1302, 461,  1838, 920,  1928, 404,  633,  858,  915,  324,
    2015, 144,  1866, 1460, 984,  2000, 2023, 1753, 1452, 1225, 131,  1103, 444,  1116, 1622, 763,  2007, 1846, 707,
    1136, 535,  1109, 1693, 1015, 850,  329,  19,   675,  2044, 475,  1358, 55,   1768, 1879, 91,   1606, 953,  1564,
    779,  1736, 118,  902,  98,   497,  938,  1473, 969,  1160, 85,   1345, 1153, 604,  1792, 1397, 828,  1203, 1280,
    989,  1887, 1243, 41,   1662, 1321, 910,  1433, 199,  1785, 1944, 1353, 1316, 1173, 1676, 310,  997,  347,  1005,
    735,  697,  207,  1836, 1730, 434,  982,  1450, 631,  2013, 533,  848,  442,  2005, 951,  116,  2042, 1766, 1790,
    1278, 936,  83,   1351, 308,  39,   1431, 629,  440,  733,  1728, 37,   731,  2040, 934,  1486, 1901, 2038, 2036,
    668,  569,  1488, 1378, 233,  1532, 1903, 1871, 1712, 284,  1490, 365,  1949, 399,  1380, 820,  111,  279,  670,
    1238, 384,  1821, 571,  596,  181,  1641, 1905, 714,  167,  654,  1873, 77,   1557, 799,  235,  1852, 510,  1257,
    1534, 1465, 1919, 576,  1492, 1072, 315,  1514, 367,  173,  975,  420,  1714, 806,  1216, 213,  286,  646,  1613,
    1296, 1382, 1416, 1094, 611,  822,  227,  841,  1586, 1951, 871,  1100, 1133, 401,  1457, 494,  601,  672,  1603,
    1002, 1447, 1240, 1941, 728,  566,  113,  305,  1638, 796,  281,  276,  1293, 1583, 573,  417,  1580, 553,  598,
    563,  427,  556,  386,  1628, 1190, 1593, 1823, 1230, 1082, 389,  1907, 1702, 1178, 586,  716,  660,  1166, 1631,
    183,  157,  140,  1842, 1643, 1524, 195,  430,  1875, 1341, 816,  73,   79,   2032, 1937, 559,  169,  223,  617,
    924,  656,  2028, 1805, 1826, 237,  337,  1681, 1995, 1854, 621,  1426, 1233, 1559, 1311, 152,  1306, 801,  300,
    258,  1193, 1536, 1143, 1410, 1335, 1467, 928,  1655, 1596, 512,  769,  881,  465,  1259, 1758, 1038, 1910, 1494,
    1027, 740,  1505, 1074, 241,  1798, 1705, 1921, 1541, 1972, 637,  578,  1049, 125,  1085, 369,  518,  252,  1287,
    175,  341,  1988, 392,  317,  751,  1957, 862,  1516, 449,  1366, 719,  1716, 1266, 702,  787,  808,  1809, 1552,
    663,  977,  1148, 1650, 1932, 422,  836,  757,  1181, 288,  1983, 1329, 547,  648,  1830, 293,  589,  1218, 541,
    1060, 408,  215,  1121, 684,  186,  1384, 889,  352,  64,   1418, 1858, 1403, 160,  1615, 263,  1689, 2019, 1298,
    1745, 529,  1169, 824,  775,  506,  380,  229,  625,  1186, 1634, 1096, 1212, 877,  148,  613,  136,  1056, 1646,
    1953, 1968, 1010, 456,  873,  1685, 1252, 1527, 843,  1198, 460,  919,  1588, 1128, 323,  143,  403,  857,  1752,
    1224, 1459, 1999, 762,  1845, 1102, 1115, 1014, 328,  1135, 1108, 54,   1878, 674,  474,  1735, 901,  1605, 1563,
    1159, 1344, 496,  1472, 1202, 988,  603,  1396, 909,  198,  1242, 1661, 1675, 996,  1943, 1315, 1835, 433,  1004,
    696,  847,  2004, 1449, 2012, 1277, 82,   115,  1765, 439,  1727, 307,  1430, 1900, 2035, 730,  933,  1531, 1870,
    568,  1377, 398,  819,  283,  364,  1820, 595,  278,  1237, 653,  76,   1640, 713,  1256, 1464, 798,  1851, 1513,
    172,  575,  1071, 212,  645,  419,  805,  610,  226,  1295, 1415, 1132, 1456, 1585, 870,  1446, 1940, 600,  1602,
    795,  275,  565,  304,  552,  562,  1582, 416,  1592, 1229, 555,  1627, 585,  659,  388,  1701, 1841, 1523, 1630,
    156,  72,   2031, 429,  1340, 923,  2027, 558,  222,  1994, 620,  1825, 336,  1305, 299,  1232, 1310, 1334, 927,
    1192, 1142, 464,  1757, 1595, 768,  1504, 240,  1909, 1026, 636,  1048, 1704, 1540, 1286, 340,  1084, 517,  861,
    448,  391,  750,  786,  1808, 718,  1265, 1931, 835,  662,  1147, 546,  1829, 1180, 1982, 407,  1120, 588,  540,
    63,   1857, 185,  888,  2018, 1744, 159,  262,  379,  624,  1168, 774,  147,  135,  1633, 1211, 455,  1684, 1645,
    1967, 918,  1127, 1526, 1197, 1223, 1998, 142,  856,  327,  1107, 1844, 1114, 900,  1562, 1877, 473,  987,  1395,
    1343, 1471, 995,  1314, 197,  1660, 2003, 2011, 432,  695,  1726, 1429, 81,   1764, 1869, 1376, 2034, 932,  594,
    1236, 818,  363,  1463, 1850, 75,   712,  644,  804,  171,  1070, 1455, 869,  225,  1414, 274,  303,  1939, 1601,
    1228, 1626, 561,  415,  1522, 155,  658,  1700, 2026, 221,  2030, 1339, 298,  1309, 619,  335,  1756, 767,  926,
    1141, 1047, 1539, 239,  1025, 447,  749,  339,  516,  834,  1146, 1807, 1264, 1119, 539,  1828, 1981, 1743, 261,
    1856, 887,  134,  1210, 623,  773,  1126, 1196, 1683, 1966, 1106, 1113, 1997, 855,  1394, 1470, 1561, 472,  2010,
    694,  1313, 1659, 1375, 931,  1428, 1763, 1849, 711,  1235, 362,  868,  1413, 803,  1069, 1625, 414,  302,  1600,
    220,  1338, 154,  1699, 766,  1140, 1308, 334,  748,  515,  1538, 1024, 538,  1980, 1145, 1263, 1209, 772,  260,
    886,  1112, 854,  1195, 1965, 693,  1658, 1469, 471,  710,  361,  930,  1762, 413,  1599, 1412, 1068, 1139, 333,
    1337, 1698, 1979, 1262, 514,  1023, 853,  1964, 771,  885,  360,  1761, 1657, 470,  332,  1697, 1598, 1067, 1963,
    884,  1261, 1022, 1696, 1066, 1760, 469,  1065, 468,  883,  1021, 1018, 1019, 467,  1020};
